/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.reactivex.rxjava3.core.Observable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.client.InboxDeliverPipeline;
import org.apache.bifromq.inbox.client.InboxFetchPipeline;
import org.apache.bifromq.inbox.client.InboxReader;
import org.apache.bifromq.inbox.rpc.proto.AttachReply;
import org.apache.bifromq.inbox.rpc.proto.AttachRequest;
import org.apache.bifromq.inbox.rpc.proto.CommitReply;
import org.apache.bifromq.inbox.rpc.proto.CommitRequest;
import org.apache.bifromq.inbox.rpc.proto.DeleteReply;
import org.apache.bifromq.inbox.rpc.proto.DeleteRequest;
import org.apache.bifromq.inbox.rpc.proto.DetachReply;
import org.apache.bifromq.inbox.rpc.proto.DetachRequest;
import org.apache.bifromq.inbox.rpc.proto.ExistReply;
import org.apache.bifromq.inbox.rpc.proto.ExistRequest;
import org.apache.bifromq.inbox.rpc.proto.ExpireAllReply;
import org.apache.bifromq.inbox.rpc.proto.ExpireAllRequest;
import org.apache.bifromq.inbox.rpc.proto.InboxServiceGrpc;
import org.apache.bifromq.inbox.rpc.proto.InboxStateReply;
import org.apache.bifromq.inbox.rpc.proto.InboxStateRequest;
import org.apache.bifromq.inbox.rpc.proto.SendLWTReply;
import org.apache.bifromq.inbox.rpc.proto.SendLWTRequest;
import org.apache.bifromq.inbox.rpc.proto.SubReply;
import org.apache.bifromq.inbox.rpc.proto.SubRequest;
import org.apache.bifromq.inbox.rpc.proto.UnsubReply;
import org.apache.bifromq.inbox.rpc.proto.UnsubRequest;
import org.apache.bifromq.inbox.util.InboxServiceUtil;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InboxClient
implements IInboxClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxClient.class);
    private final AtomicBoolean hasStopped = new AtomicBoolean();
    private final IRPCClient rpcClient;
    private final LoadingCache<FetchPipelineKey, InboxFetchPipeline> fetchPipelineCache;

    InboxClient(IRPCClient rpcClient) {
        this.rpcClient = rpcClient;
        this.fetchPipelineCache = Caffeine.newBuilder().weakValues().executor(MoreExecutors.directExecutor()).build(key -> new InboxFetchPipeline(key.tenantId, key.delivererKey, rpcClient));
    }

    public IDeliverer open(String delivererKey) {
        Preconditions.checkState((!this.hasStopped.get() ? 1 : 0) != 0);
        return new InboxDeliverPipeline(delivererKey, this.rpcClient);
    }

    public Observable<IConnectable.ConnState> connState() {
        return this.rpcClient.connState();
    }

    @Override
    public IInboxClient.IInboxReader openInboxReader(String tenantId, String inboxId, long incarnation) {
        return new InboxReader(inboxId, incarnation, (InboxFetchPipeline)this.fetchPipelineCache.get((Object)new FetchPipelineKey(tenantId, InboxServiceUtil.getDelivererKey((String)tenantId, (String)inboxId))));
    }

    public CompletableFuture<CheckReply> check(CheckRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getCheckSubscriptionsMethod()).exceptionally(e -> {
            log.debug("Failed to handle CheckRequest", e);
            CheckReply.Builder replyBuilder = CheckReply.newBuilder();
            for (MatchInfo matchInfo : request.getMatchInfoList()) {
                replyBuilder.addCode(CheckReply.Code.ERROR);
            }
            return replyBuilder.build();
        });
    }

    @Override
    public CompletableFuture<CommitReply> commit(CommitRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getCommitMethod()).exceptionally(e -> {
            log.debug("Failed to commit inbox", e);
            return CommitReply.newBuilder().setReqId(request.getReqId()).setCode(CommitReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<InboxStateReply> state(long reqId, String tenantId, String userId, String clientId) {
        return this.rpcClient.invoke(tenantId, null, (Object)InboxStateRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setInboxId(userId + "/" + clientId).setNow(System.currentTimeMillis()).build(), InboxServiceGrpc.getStateMethod()).exceptionally(e -> {
            log.debug("Failed to handle InboxStateRequest", e);
            return InboxStateReply.newBuilder().setReqId(reqId).setCode(InboxStateReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<ExistReply> exist(ExistRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getExistMethod()).exceptionally(e -> {
            log.debug("Failed to handle ExistRequest", e);
            return ExistReply.newBuilder().setReqId(request.getReqId()).setCode(ExistReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<AttachReply> attach(AttachRequest request) {
        return this.rpcClient.invoke(request.getClient().getTenantId(), null, (Object)request, InboxServiceGrpc.getAttachMethod()).exceptionally(e -> {
            log.debug("Failed to handle AttachRequest", e);
            return AttachReply.newBuilder().setReqId(request.getReqId()).setCode(AttachReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<DetachReply> detach(DetachRequest request) {
        return this.rpcClient.invoke(request.getClient().getTenantId(), null, (Object)request, InboxServiceGrpc.getDetachMethod()).exceptionally(e -> {
            log.debug("Failed to handle DetachRequest", e);
            return DetachReply.newBuilder().setReqId(request.getReqId()).setCode(DetachReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<SubReply> sub(SubRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getSubMethod()).exceptionally(e -> {
            log.debug("Failed to handle SubRequest", e);
            return SubReply.newBuilder().setReqId(request.getReqId()).setCode(SubReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<UnsubReply> unsub(UnsubRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getUnsubMethod()).exceptionally(e -> {
            log.debug("Failed to handle UnsubRequest", e);
            return UnsubReply.newBuilder().setReqId(request.getReqId()).setCode(UnsubReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<SendLWTReply> sendLWT(SendLWTRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getSendLWTMethod()).exceptionally(e -> {
            log.debug("Failed to handle SendLWTRequest", e);
            return SendLWTReply.newBuilder().setReqId(request.getReqId()).setCode(SendLWTReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<DeleteReply> delete(DeleteRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getDeleteMethod()).exceptionally(e -> {
            log.debug("Failed to handle DeleteRequest", e);
            return DeleteReply.newBuilder().setReqId(request.getReqId()).setCode(DeleteReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<ExpireAllReply> expireAll(ExpireAllRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, InboxServiceGrpc.getExpireAllMethod()).exceptionally(e -> {
            log.debug("Failed to handle ExpireAllRequest", e);
            return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setCode(ExpireAllReply.Code.ERROR).build();
        });
    }

    @Override
    public void close() {
        if (this.hasStopped.compareAndSet(false, true)) {
            log.debug("Closing inbox client");
            this.fetchPipelineCache.asMap().forEach((k, v) -> v.close());
            this.fetchPipelineCache.invalidateAll();
            log.debug("Stopping rpc client");
            this.rpcClient.stop();
            log.debug("Inbox client closed");
        }
    }

    private record FetchPipelineKey(String tenantId, String delivererKey) {
    }
}

