/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store;

import java.util.List;

public class RetainMatcher {
    public static MatchResult match(List<String> topicLevels, List<String> matchLevels) {
        boolean matchMultiLevel = matchLevels.get(matchLevels.size() - 1).equals("#");
        if (matchMultiLevel && topicLevels.size() + 1 < matchLevels.size()) {
            return MatchResult.MISMATCH_AND_STOP;
        }
        if (!matchMultiLevel && topicLevels.size() != matchLevels.size()) {
            return MatchResult.MISMATCH_AND_STOP;
        }
        boolean singleLevelMatched = false;
        block8: for (int i = 0; i < topicLevels.size(); ++i) {
            String matchLevel;
            switch (matchLevel = matchLevels.get(i)) {
                case "+": {
                    singleLevelMatched = true;
                    continue block8;
                }
                case "#": {
                    return MatchResult.MATCHED_AND_CONTINUE;
                }
                default: {
                    int c = matchLevel.compareTo(topicLevels.get(i));
                    if (c == 0) continue block8;
                    if (singleLevelMatched) {
                        if (c < 0) {
                            return MatchResult.MISMATCH_AND_STOP;
                        }
                        return MatchResult.MISMATCH_AND_CONTINUE;
                    }
                    if (matchMultiLevel) {
                        if (matchLevel.isEmpty()) {
                            return MatchResult.MATCHED_AND_CONTINUE;
                        }
                        return MatchResult.MISMATCH_AND_CONTINUE;
                    }
                    return MatchResult.MISMATCH_AND_STOP;
                }
            }
        }
        if (singleLevelMatched || matchMultiLevel) {
            return MatchResult.MATCHED_AND_CONTINUE;
        }
        return MatchResult.MATCHED_AND_STOP;
    }

    public static enum MatchResult {
        MATCHED_AND_STOP,
        MATCHED_AND_CONTINUE,
        MISMATCH_AND_CONTINUE,
        MISMATCH_AND_STOP;

    }
}

