/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.SSLContextConfig;
import org.apache.bifromq.starter.module.SSLUtil;
import org.apache.bifromq.starter.utils.ResourceUtil;

public class RPCClientSSLContextModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Optional<SslContext>>(){}).annotatedWith((Annotation)Names.named((String)"rpcClientSSLContext")).toProvider(RPCClientSSLContextProvider.class).in(Singleton.class);
    }

    private static class RPCClientSSLContextProvider
    implements Provider<Optional<SslContext>> {
        private final StandaloneConfig config;

        @Inject
        private RPCClientSSLContextProvider(StandaloneConfig config) {
            this.config = config;
        }

        public Optional<SslContext> get() {
            if (this.config.getRpcConfig().isEnableSSL()) {
                return Optional.of(this.buildRPCClientSslContext(this.config.getRpcConfig().getClientSSLConfig()));
            }
            return Optional.empty();
        }

        protected SslContext buildRPCClientSslContext(SSLContextConfig config) {
            try {
                SslProvider sslProvider = SSLUtil.defaultSslProvider();
                SslContextBuilder sslCtxBuilder = GrpcSslContexts.forClient().sslProvider(sslProvider);
                if (config.getCertFile() != null && config.getKeyFile() != null) {
                    sslCtxBuilder.keyManager(ResourceUtil.loadFile(config.getCertFile()), ResourceUtil.loadFile(config.getKeyFile()));
                }
                if (Strings.isNullOrEmpty((String)config.getTrustCertsFile())) {
                    sslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                } else {
                    sslCtxBuilder.trustManager(ResourceUtil.loadFile(config.getTrustCertsFile()));
                }
                return sslCtxBuilder.build();
            }
            catch (Throwable e) {
                throw new RuntimeException("Fail to initialize RPC client SSLContext", e);
            }
        }
    }
}

