/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.RangeLeader;

public class KVRangeRouterUtil {
    public static Optional<KVRangeSetting> findByKey(ByteString key, NavigableMap<Boundary, KVRangeSetting> effectiveRouter) {
        Map.Entry<Boundary, KVRangeSetting> entry = effectiveRouter.floorEntry(Boundary.newBuilder().setStartKey(key).build());
        if (entry != null) {
            KVRangeSetting setting = entry.getValue();
            if (BoundaryUtil.inRange((ByteString)key, (Boundary)entry.getKey())) {
                return Optional.of(setting);
            }
        }
        return Optional.empty();
    }

    public static Collection<KVRangeSetting> findByBoundary(Boundary boundary, NavigableMap<Boundary, KVRangeSetting> effectiveRouter) {
        if (effectiveRouter.isEmpty()) {
            return Collections.emptyList();
        }
        if (!boundary.hasStartKey() && !boundary.hasEndKey()) {
            return effectiveRouter.values();
        }
        if (!boundary.hasStartKey()) {
            Boundary boundaryEnd = Boundary.newBuilder().setStartKey(boundary.getEndKey()).setEndKey(boundary.getEndKey()).build();
            return effectiveRouter.headMap(boundaryEnd, false).values();
        }
        if (!boundary.hasEndKey()) {
            Boundary boundaryStart = Boundary.newBuilder().setStartKey(boundary.getStartKey()).setEndKey(boundary.getStartKey()).build();
            Boundary floorBoundary = effectiveRouter.floorKey(boundaryStart);
            if (floorBoundary == null) {
                floorBoundary = (Boundary)effectiveRouter.firstKey();
            }
            boolean includeFromKey = BoundaryUtil.compareEndKeys((ByteString)BoundaryUtil.endKey((Boundary)floorBoundary), (ByteString)boundary.getStartKey()) > 0;
            return effectiveRouter.tailMap(floorBoundary, includeFromKey).values();
        }
        Boundary boundaryStart = Boundary.newBuilder().setStartKey(boundary.getStartKey()).setEndKey(boundary.getStartKey()).build();
        Boundary boundaryEnd = Boundary.newBuilder().setStartKey(boundary.getEndKey()).setEndKey(boundary.getEndKey()).build();
        Boundary floorBoundary = effectiveRouter.floorKey(boundaryStart);
        if (floorBoundary == null) {
            floorBoundary = (Boundary)effectiveRouter.firstKey();
        }
        boolean includeFromKey = BoundaryUtil.compareEndKeys((ByteString)BoundaryUtil.endKey((Boundary)floorBoundary), (ByteString)boundary.getStartKey()) > 0;
        return effectiveRouter.subMap(floorBoundary, includeFromKey, boundaryEnd, false).values();
    }

    public static Map<KVRangeId, Map<String, KVRangeDescriptor>> refreshRouteMap(Map<KVRangeId, Map<String, KVRangeDescriptor>> current, Map<KVRangeId, Map<String, KVRangeDescriptor>> patch) {
        HashMap<KVRangeId, Map<String, KVRangeDescriptor>> currRouteMap = new HashMap<KVRangeId, Map<String, KVRangeDescriptor>>(current);
        patch.forEach((rangeId, replicaMap) -> replicaMap.forEach((storeId, rangeDesc) -> KVRangeRouterUtil.patchRouteMap(storeId, rangeDesc, currRouteMap)));
        currRouteMap.keySet().removeIf(rangeId -> !patch.containsKey(rangeId));
        currRouteMap.forEach((rangeId, replicaMap) -> replicaMap.keySet().removeIf(storeId -> !((Map)patch.get(rangeId)).containsKey(storeId)));
        return currRouteMap;
    }

    public static Map<KVRangeId, Map<String, KVRangeDescriptor>> patchRouteMap(String storeId, KVRangeDescriptor rangeDesc, Map<KVRangeId, Map<String, KVRangeDescriptor>> current) {
        current.compute(rangeDesc.getId(), (k, v) -> {
            if (v == null) {
                v = new HashMap<String, KVRangeDescriptor>();
            }
            v.compute(storeId, (sk, sv) -> {
                if (sv == null) {
                    return rangeDesc;
                }
                if (rangeDesc.getHlc() > sv.getHlc()) {
                    return rangeDesc;
                }
                return sv;
            });
            return v;
        });
        return current;
    }

    public static NavigableMap<Boundary, KVRangeSetting> buildClientRoute(String clusterId, NavigableMap<Boundary, RangeLeader> leaderMap, Map<KVRangeId, Map<String, KVRangeDescriptor>> routeMap) {
        TreeMap<Boundary, KVRangeSetting> router = new TreeMap<Boundary, KVRangeSetting>(BoundaryUtil::compare);
        for (Boundary boundary : leaderMap.keySet()) {
            RangeLeader rangeLeader = (RangeLeader)leaderMap.get(boundary);
            KVRangeDescriptor leaderDesc = rangeLeader.descriptor();
            Map<String, KVRangeDescriptor> allReplicas = routeMap.get(leaderDesc.getId());
            router.put(boundary, new KVRangeSetting(clusterId, rangeLeader.storeId(), allReplicas));
        }
        return router;
    }
}

