/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.type.QoS;

public class TenantSettings {
    public final boolean mqtt3Enabled;
    public final boolean mqtt4Enabled;
    public final boolean mqtt5Enabled;
    public final boolean debugMode;
    public final boolean noLWTWhenServerShuttingDown;
    public final boolean forceTransient;
    public final boolean payloadFormatValidationEnabled;
    public final boolean retainEnabled;
    public final boolean wildcardSubscriptionEnabled;
    public final boolean subscriptionIdentifierEnabled;
    public final boolean sharedSubscriptionEnabled;
    public final QoS maxQoS;
    public final int minKeepAliveSeconds;
    public final int maxSEI;
    public final int minSEI;
    public final int maxTopicLevelLength;
    public final int maxTopicLevels;
    public final int maxTopicLength;
    public final int maxPacketSize;
    public final int maxLastWillSize;
    public final int maxTopicAlias;
    public final long inboundBandwidth;
    public final long outboundBandwidth;
    public final int receiveMaximum;
    public final int minSendPerSec;
    public final int maxMsgPerSec;
    public final int maxResendTimes;
    public final int resendTimeoutSeconds;
    public final int maxTopicFiltersPerSub;
    public final int inboxQueueLength;
    public final boolean inboxDropOldest;
    public final int retainMatchLimit;
    public final int maxTopicFiltersPerInbox;

    public TenantSettings(String tenantId, ISettingProvider provider) {
        this.mqtt3Enabled = (Boolean)provider.provide(Setting.MQTT3Enabled, tenantId);
        this.mqtt4Enabled = (Boolean)provider.provide(Setting.MQTT4Enabled, tenantId);
        this.mqtt5Enabled = (Boolean)provider.provide(Setting.MQTT5Enabled, tenantId);
        this.debugMode = (Boolean)provider.provide(Setting.DebugModeEnabled, tenantId);
        this.noLWTWhenServerShuttingDown = (Boolean)provider.provide(Setting.NoLWTWhenServerShuttingDown, tenantId);
        this.forceTransient = (Boolean)provider.provide(Setting.ForceTransient, tenantId);
        this.payloadFormatValidationEnabled = (Boolean)provider.provide(Setting.PayloadFormatValidationEnabled, tenantId);
        this.retainEnabled = (Boolean)provider.provide(Setting.RetainEnabled, tenantId);
        this.wildcardSubscriptionEnabled = (Boolean)provider.provide(Setting.WildcardSubscriptionEnabled, tenantId);
        this.subscriptionIdentifierEnabled = (Boolean)provider.provide(Setting.SubscriptionIdentifierEnabled, tenantId);
        this.sharedSubscriptionEnabled = (Boolean)provider.provide(Setting.SharedSubscriptionEnabled, tenantId);
        this.maxQoS = QoS.forNumber((int)((Integer)provider.provide(Setting.MaximumQoS, tenantId)));
        this.minKeepAliveSeconds = (Integer)provider.provide(Setting.MinKeepAliveSeconds, tenantId);
        this.maxSEI = (Integer)provider.provide(Setting.MaxSessionExpirySeconds, tenantId);
        this.minSEI = (Integer)provider.provide(Setting.MinSessionExpirySeconds, tenantId);
        this.maxTopicLevelLength = (Integer)provider.provide(Setting.MaxTopicLevelLength, tenantId);
        this.maxTopicLevels = (Integer)provider.provide(Setting.MaxTopicLevels, tenantId);
        this.maxTopicLength = (Integer)provider.provide(Setting.MaxTopicLength, tenantId);
        this.maxPacketSize = (Integer)provider.provide(Setting.MaxUserPayloadBytes, tenantId);
        this.maxLastWillSize = Math.min((Integer)provider.provide(Setting.MaxLastWillBytes, tenantId), this.maxPacketSize);
        this.maxTopicAlias = (Integer)provider.provide(Setting.MaxTopicAlias, tenantId);
        this.inboundBandwidth = (Long)provider.provide(Setting.InBoundBandWidth, tenantId);
        this.outboundBandwidth = (Long)provider.provide(Setting.OutBoundBandWidth, tenantId);
        this.maxMsgPerSec = (Integer)provider.provide(Setting.MsgPubPerSec, tenantId);
        this.maxResendTimes = (Integer)provider.provide(Setting.MaxResendTimes, tenantId);
        this.resendTimeoutSeconds = (Integer)provider.provide(Setting.ResendTimeoutSeconds, tenantId);
        this.receiveMaximum = (Integer)provider.provide(Setting.ReceivingMaximum, tenantId);
        this.minSendPerSec = (Integer)provider.provide(Setting.MinSendPerSec, tenantId);
        this.maxTopicFiltersPerSub = (Integer)provider.provide(Setting.MaxTopicFiltersPerSub, tenantId);
        this.inboxQueueLength = (Integer)provider.provide(Setting.SessionInboxSize, tenantId);
        this.inboxDropOldest = (Boolean)provider.provide(Setting.QoS0DropOldest, tenantId);
        this.retainMatchLimit = (Integer)provider.provide(Setting.RetainMessageMatchLimit, tenantId);
        this.maxTopicFiltersPerInbox = (Integer)provider.provide(Setting.MaxTopicFiltersPerInbox, tenantId);
    }
}

