/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.broker;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.apache.polaris.service.auth.PolarisCredential;
import org.apache.polaris.service.auth.internal.broker.InternalPolarisToken;
import org.immutables.value.Generated;

@Generated(from="InternalPolarisToken", generator="Immutables")
final class ImmutableInternalPolarisToken
extends InternalPolarisToken {
    private final String principalName;
    private final Long principalId;
    private final String clientId;
    private final String scope;
    private transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long PRINCIPAL_ROLES_LAZY_INIT_BIT = 1L;
    private transient Set<String> principalRoles;

    private ImmutableInternalPolarisToken(String principalName, Long principalId, String clientId, String scope) {
        this.principalName = principalName;
        this.principalId = principalId;
        this.clientId = clientId;
        this.scope = scope;
    }

    @Override
    public String getPrincipalName() {
        return this.principalName;
    }

    @Override
    public Long getPrincipalId() {
        return this.principalId;
    }

    @Override
    String getClientId() {
        return this.clientId;
    }

    @Override
    String getScope() {
        return this.scope;
    }

    public final ImmutableInternalPolarisToken withPrincipalName(String value) {
        String newValue = Objects.requireNonNull(value, "principalName");
        if (this.principalName.equals(newValue)) {
            return this;
        }
        return new ImmutableInternalPolarisToken(newValue, this.principalId, this.clientId, this.scope);
    }

    public final ImmutableInternalPolarisToken withPrincipalId(Long value) {
        Long newValue = Objects.requireNonNull(value, "principalId");
        if (this.principalId.equals(newValue)) {
            return this;
        }
        return new ImmutableInternalPolarisToken(this.principalName, newValue, this.clientId, this.scope);
    }

    public final ImmutableInternalPolarisToken withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return new ImmutableInternalPolarisToken(this.principalName, this.principalId, newValue, this.scope);
    }

    public final ImmutableInternalPolarisToken withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (this.scope.equals(newValue)) {
            return this;
        }
        return new ImmutableInternalPolarisToken(this.principalName, this.principalId, this.clientId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInternalPolarisToken && this.equalsByValue((ImmutableInternalPolarisToken)another);
    }

    private boolean equalsByValue(ImmutableInternalPolarisToken another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.principalName.equals(another.principalName) && this.principalId.equals(another.principalId) && this.clientId.equals(another.clientId) && this.scope.equals(another.scope);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.principalName.hashCode();
        h += (h << 5) + this.principalId.hashCode();
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.scope.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InternalPolarisToken").omitNullValues().add("principalName", (Object)this.principalName).add("principalId", (Object)this.principalId).add("clientId", (Object)this.clientId).add("scope", (Object)this.scope).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPrincipalRoles() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableInternalPolarisToken immutableInternalPolarisToken = this;
            synchronized (immutableInternalPolarisToken) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.principalRoles = Objects.requireNonNull(super.getPrincipalRoles(), "principalRoles");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.principalRoles;
    }

    public static ImmutableInternalPolarisToken copyOf(InternalPolarisToken instance) {
        if (instance instanceof ImmutableInternalPolarisToken) {
            return (ImmutableInternalPolarisToken)instance;
        }
        return ImmutableInternalPolarisToken.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableInternalPolarisToken.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InternalPolarisToken", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PRINCIPAL_NAME = 1L;
        private static final long INIT_BIT_PRINCIPAL_ID = 2L;
        private static final long INIT_BIT_CLIENT_ID = 4L;
        private static final long INIT_BIT_SCOPE = 8L;
        private long initBits = 15L;
        private String principalName;
        private Long principalId;
        private String clientId;
        private String scope;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InternalPolarisToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PolarisCredential instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Long principalIdValue;
            String principalNameValue;
            PolarisCredential instance;
            long bits = 0L;
            if (object instanceof InternalPolarisToken) {
                instance = (InternalPolarisToken)object;
                if ((bits & 1L) == 0L) {
                    principalNameValue = ((InternalPolarisToken)instance).getPrincipalName();
                    if (principalNameValue != null) {
                        this.principalName(principalNameValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    principalIdValue = ((InternalPolarisToken)instance).getPrincipalId();
                    if (principalIdValue != null) {
                        this.principalId(principalIdValue);
                    }
                    bits |= 2L;
                }
                this.clientId(((InternalPolarisToken)instance).getClientId());
                this.scope(((InternalPolarisToken)instance).getScope());
            }
            if (object instanceof PolarisCredential) {
                instance = (PolarisCredential)object;
                if ((bits & 1L) == 0L) {
                    principalNameValue = instance.getPrincipalName();
                    if (principalNameValue != null) {
                        this.principalName(principalNameValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    principalIdValue = instance.getPrincipalId();
                    if (principalIdValue != null) {
                        this.principalId(principalIdValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder principalName(String principalName) {
            this.principalName = Objects.requireNonNull(principalName, "principalName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder principalId(Long principalId) {
            this.principalId = Objects.requireNonNull(principalId, "principalId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 15L;
            this.principalName = null;
            this.principalId = null;
            this.clientId = null;
            this.scope = null;
            return this;
        }

        public ImmutableInternalPolarisToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInternalPolarisToken(this.principalName, this.principalId, this.clientId, this.scope);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("principalName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("principalId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build InternalPolarisToken, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

