/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.common.regexp;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.tsfile.common.regexp.DFA;

public class NFA {
    private final int start;
    private final int accept;
    private final List<List<Transition>> transitions;

    private NFA(int start, int accept, List<List<Transition>> transitions) {
        this.start = start;
        this.accept = accept;
        this.transitions = Objects.requireNonNull(transitions, "transitions is null");
    }

    public DFA toDfa() {
        HashMap<Set, Integer> activeStates = new HashMap<Set, Integer>();
        DFA.Builder builder = new DFA.Builder();
        HashSet<Integer> initial = new HashSet<Integer>();
        initial.add(this.start);
        ArrayDeque queue = new ArrayDeque();
        queue.add(initial);
        int dfaStartState = builder.addStartState(initial.contains(this.accept));
        activeStates.put(initial, dfaStartState);
        HashSet<Set> visited = new HashSet<Set>();
        while (!queue.isEmpty()) {
            Set current = (Set)queue.poll();
            if (!visited.add(current)) continue;
            for (int byteValue = 0; byteValue < 256; ++byteValue) {
                HashSet<Integer> next = new HashSet<Integer>();
                Iterator iterator = current.iterator();
                while (iterator.hasNext()) {
                    int nfaState = (Integer)iterator.next();
                    for (Transition transition : this.transitions(nfaState)) {
                        Prefix prefixTransition;
                        Condition condition = transition.getCondition();
                        int target = transition.getTarget();
                        if (condition instanceof Value) {
                            Value valueTransition = (Value)condition;
                            if (valueTransition.getValue() != (byte)byteValue) continue;
                            next.add(target);
                            continue;
                        }
                        if (!(condition instanceof Prefix) || byteValue >>> 8 - (prefixTransition = (Prefix)condition).getBits() != prefixTransition.getPrefix()) continue;
                        next.add(target);
                    }
                }
                if (next.isEmpty()) continue;
                int from = (Integer)activeStates.get(current);
                int to = activeStates.computeIfAbsent(next, nfaStates -> builder.addState(nfaStates.contains(this.accept)));
                builder.addTransition(from, byteValue, to);
                queue.add(next);
            }
        }
        return builder.build();
    }

    private List<Transition> transitions(int state) {
        return this.transitions.get(state);
    }

    static class Transition {
        private final int target;
        private final Condition condition;

        public Transition(int target, Condition condition) {
            this.target = target;
            this.condition = condition;
        }

        public int getTarget() {
            return this.target;
        }

        public Condition getCondition() {
            return this.condition;
        }
    }

    static interface Condition {
    }

    static class Value
    implements Condition {
        private final byte value;

        public Value(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    static class Prefix
    implements Condition {
        private final int prefix;
        private final int bits;

        public Prefix(int prefix, int bits) {
            this.prefix = prefix;
            this.bits = bits;
        }

        public int getPrefix() {
            return this.prefix;
        }

        public int getBits() {
            return this.bits;
        }
    }

    public static class Builder {
        private int nextId;
        private int start;
        private int accept;
        private final List<List<Transition>> transitions = new ArrayList<List<Transition>>();

        public int addState() {
            this.transitions.add(new ArrayList());
            return this.nextId++;
        }

        public int addStartState() {
            this.start = this.addState();
            return this.start;
        }

        public void setAccept(int state) {
            this.accept = state;
        }

        public void addTransition(int from, Condition condition, int to) {
            this.transitions.get(from).add(new Transition(to, condition));
        }

        public NFA build() {
            return new NFA(this.start, this.accept, this.transitions);
        }
    }
}

