/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventParser;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletInsertionEventTablePatternParser
extends TabletInsertionEventParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TabletInsertionEventTablePatternParser.class);
    private final TablePattern pattern;

    public TabletInsertionEventTablePatternParser(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, InsertNode insertNode, TablePattern pattern) {
        super(pipeTaskMeta, sourceEvent);
        this.pattern = pattern;
        if (insertNode instanceof RelationalInsertRowNode) {
            this.parse((RelationalInsertRowNode)insertNode);
        } else if (insertNode instanceof RelationalInsertTabletNode) {
            this.parse((RelationalInsertTabletNode)insertNode);
        } else {
            throw new UnSupportedDataTypeException(String.format("InsertNode type %s is not supported.", insertNode.getClass().getName()));
        }
    }

    public TabletInsertionEventTablePatternParser(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, Tablet tablet, boolean isAligned, TablePattern pattern) {
        super(pipeTaskMeta, sourceEvent);
        this.pattern = pattern;
        this.parse(tablet, isAligned);
    }

    @Override
    protected Object getPattern() {
        return this.pattern;
    }

    @Override
    protected void generateColumnIndexMapper(String[] originMeasurementList, Integer[] originColumnIndex2FilteredColumnIndexMapperList) {
        int originColumnSize = originMeasurementList.length;
        for (int i = 0; i < originColumnSize; ++i) {
            originColumnIndex2FilteredColumnIndexMapperList[i] = i;
        }
    }

    @Override
    public List<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn("TablePatternParser does not support row by row processing");
        }
        return Collections.emptyList();
    }

    @Override
    public List<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn("TablePatternParser does not support tablet processing");
        }
        return Collections.emptyList();
    }

    @Override
    public Tablet convertToTablet() {
        Tablet newTablet;
        if (this.tablet != null) {
            return this.tablet;
        }
        this.tablet = newTablet = new Tablet(Objects.nonNull(this.deviceIdString) ? this.deviceIdString : this.deviceId.getTableName(), Arrays.asList(this.measurementSchemaList), Arrays.asList(this.valueColumnTypes), this.timestampColumn, this.valueColumns, this.nullValueColumnBitmaps, this.rowCount);
        return this.tablet;
    }
}

