/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ChildReplacer;

public abstract class SimplePlanRewriter<C>
extends PlanVisitor<PlanNode, RewriteContext<C>> {
    public static <C> PlanNode rewriteWith(SimplePlanRewriter<C> rewriter, PlanNode node) {
        return (PlanNode)node.accept(rewriter, new RewriteContext(rewriter, null));
    }

    public static <C> PlanNode rewriteWith(SimplePlanRewriter<C> rewriter, PlanNode node, C context) {
        return (PlanNode)node.accept(rewriter, new RewriteContext(rewriter, context));
    }

    @Override
    public PlanNode visitPlan(PlanNode node, RewriteContext<C> context) {
        return context.defaultRewrite(node, context.get());
    }

    public static class RewriteContext<C> {
        private final C userContext;
        private final SimplePlanRewriter<C> nodeRewriter;

        private RewriteContext(SimplePlanRewriter<C> nodeRewriter, C userContext) {
            this.nodeRewriter = nodeRewriter;
            this.userContext = userContext;
        }

        public C get() {
            return this.userContext;
        }

        public PlanNode defaultRewrite(PlanNode node) {
            return this.defaultRewrite(node, null);
        }

        public PlanNode defaultRewrite(PlanNode node, C context) {
            ImmutableList.Builder children = ImmutableList.builderWithExpectedSize((int)node.getChildren().size());
            node.getChildren().forEach(source -> children.add((Object)this.rewrite((PlanNode)source, context)));
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)children.build());
        }

        public PlanNode rewrite(PlanNode node, C userContext) {
            PlanNode result = (PlanNode)node.accept(this.nodeRewriter, new RewriteContext<C>(this.nodeRewriter, userContext));
            return (PlanNode)Verify.verifyNotNull((Object)result, (String)"nodeRewriter returned null for %s", (Object[])new Object[]{node.getClass().getName()});
        }

        public PlanNode rewrite(PlanNode node) {
            return this.rewrite(node, null);
        }
    }
}

