/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class BinaryArithmeticOperatorNode
extends BinaryOperatorNode {
    static final int K_DIVIDE = 0;
    static final int K_MINUS = 1;
    static final int K_PLUS = 2;
    static final int K_TIMES = 3;
    static final int K_MOD = 4;
    final int kind;

    BinaryArithmeticOperatorNode(int n, ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) {
        super(valueNode, valueNode2, "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue", contextManager);
        String string;
        this.kind = n;
        String string2 = switch (n) {
            case 0 -> {
                string = "/";
                yield "divide";
            }
            case 1 -> {
                string = "-";
                yield "minus";
            }
            case 2 -> {
                string = "+";
                yield "plus";
            }
            case 3 -> {
                string = "*";
                yield "times";
            }
            case 4 -> {
                string = "mod";
                yield "mod";
            }
            default -> {
                string = null;
                yield null;
            }
        };
        this.setOperator(string);
        this.setMethodName(string2);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        super.bindExpression(fromList, subqueryList, list);
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        DataTypeDescriptor dataTypeDescriptor = this.leftOperand.getTypeServices();
        DataTypeDescriptor dataTypeDescriptor2 = this.rightOperand.getTypeServices();
        if (typeId.isStringTypeId() && typeId2.isNumericTypeId()) {
            boolean bl = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
            int n = dataTypeDescriptor2.getPrecision();
            int n2 = dataTypeDescriptor2.getScale();
            int n3 = dataTypeDescriptor2.getMaximumWidth();
            if (typeId2.isDecimalTypeId()) {
                int n4 = dataTypeDescriptor.getMaximumWidth();
                n2 += n4;
                n3 = (n += 2 * n4) + 3;
            }
            this.leftOperand = new CastNode(this.leftOperand, new DataTypeDescriptor(typeId2, n, n2, bl, n3), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (typeId2.isStringTypeId() && typeId.isNumericTypeId()) {
            boolean bl = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
            int n = dataTypeDescriptor.getPrecision();
            int n5 = dataTypeDescriptor.getScale();
            int n6 = dataTypeDescriptor.getMaximumWidth();
            if (typeId.isDecimalTypeId()) {
                int n7 = dataTypeDescriptor2.getMaximumWidth();
                n5 += n7;
                n6 = (n += 2 * n7) + 3;
            }
            this.rightOperand = new CastNode(this.rightOperand, new DataTypeDescriptor(typeId, n, n5, bl, n6), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        this.setType(this.leftOperand.getTypeCompiler().resolveArithmeticOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices(), this.operator));
        return this;
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((BinaryArithmeticOperatorNode)valueNode).kind == this.kind;
    }
}

