/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.aggregation;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.collector.CollectorType;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.StringLiteralExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class CountExpression<T>
extends AbstractAggregationExpression<T, Number> {
    public CountExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireMinParameters(1, args, this);
        FunctionParametersValidator.requireMaxParameters(2, args, this);
    }

    @Override
    public CollectorType getCollectorType() {
        return CollectorType.COUNTING;
    }

    @Override
    public Number aggregate(List<T> items) {
        Stream stream;
        if (this.getChildren().size() == 1) {
            ExpressionNode expression = this.getChild(0);
            stream = items.stream().map(expression);
        } else {
            ExpressionNode first = this.getChild(0);
            if (!(first instanceof StringLiteralExpression) || !Objects.equals("distinct", String.valueOf(first.apply(null)).toLowerCase(Locale.US))) {
                throw QueryParsingException.of("Function COUNT first argument must be 'distinct'", new Object[0]);
            }
            ExpressionNode expression = this.getChild(1);
            stream = items.stream().map(expression);
            stream = stream.distinct();
        }
        return NumberConverter.narrow(stream.filter(Objects::nonNull).count());
    }
}

