/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public enum JmsMessageTypeAnnotation {
    MESSAGE(0),
    OBJECT_MESSAGE(1),
    MAP_MESSAGE(2),
    BYTES_MESSAGE(3),
    STREAM_MESSAGE(4),
    TEXT_MESSAGE(5);

    public static final Symbol ANNOTATION_KEY;
    private final byte _type;

    private JmsMessageTypeAnnotation(byte value) {
        this._type = value;
    }

    public byte getType() {
        return this._type;
    }

    public static JmsMessageTypeAnnotation valueOf(byte type) {
        switch (type) {
            case 0: {
                return MESSAGE;
            }
            case 1: {
                return OBJECT_MESSAGE;
            }
            case 2: {
                return MAP_MESSAGE;
            }
            case 3: {
                return BYTES_MESSAGE;
            }
            case 4: {
                return STREAM_MESSAGE;
            }
            case 5: {
                return TEXT_MESSAGE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s type %d", JmsMessageTypeAnnotation.class.getSimpleName(), type));
    }

    static {
        ANNOTATION_KEY = Symbol.valueOf("x-opt-jms-msg-type");
    }
}

