/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.otlp.metrics;

import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.shaded.io.grpc.ManagedChannel;
import org.apache.rocketmq.shaded.io.opentelemetry.api.internal.Utils;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.otlp.metrics.MarshalerMetricsServiceGrpc;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;

public final class OtlpGrpcMetricExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.metrics.v1.MetricsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.metrics.v1.MetricsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    final GrpcExporterBuilder<MetricsRequestMarshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;

    OtlpGrpcMetricExporterBuilder() {
        this.delegate = GrpcExporter.builder("metric", 10L, DEFAULT_ENDPOINT, () -> MarshalerMetricsServiceGrpc::newFutureStub, GRPC_SERVICE_NAME, GRPC_ENDPOINT_PATH);
    }

    @Deprecated
    public OtlpGrpcMetricExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.delegate.setTimeout(timeout);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument(compressionMethod.equals("gzip") || compressionMethod.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustedCertificates(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setClientTls(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpGrpcMetricExporter build() {
        return new OtlpGrpcMetricExporter(this.delegate.build(), this.aggregationTemporalitySelector);
    }
}

