/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.sql.Date;
import java.sql.Time;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;

public final class TemporalDate
extends java.util.Date
implements LenientComparable {
    private static final long serialVersionUID = 8239300258490556354L;
    public final Temporal temporal;

    public TemporalDate(long time, Temporal temporal) {
        super(time);
        this.temporal = temporal;
    }

    public static java.util.Date toDate(Temporal time) {
        return time == null ? null : new TemporalDate(TemporalDate.toInstant(time, ZoneOffset.UTC).toEpochMilli(), time);
    }

    public static java.util.Date toDate(Instant time) {
        return time == null ? null : new TemporalDate(time.toEpochMilli(), time);
    }

    public static Temporal toTemporal(java.util.Date time) {
        if (time == null) {
            return null;
        }
        if (time instanceof TemporalDate) {
            return ((TemporalDate)time).temporal;
        }
        try {
            return time.toInstant();
        }
        catch (UnsupportedOperationException e) {
            if (time instanceof Date) {
                return LocalDate.ofEpochDay(time.getTime() / 86400000L);
            }
            if (time instanceof Time) {
                return LocalTime.ofSecondOfDay(time.getTime());
            }
            throw e;
        }
    }

    public static Instant toInstant(java.util.Date time) {
        return time == null ? null : time.toInstant();
    }

    public static Instant toInstant(TemporalAccessor date, ZoneId zone) {
        ChronoField nano;
        Instant time;
        if (date == null) {
            return null;
        }
        if (date instanceof Instant) {
            return (Instant)date;
        }
        if (date instanceof OffsetDateTime) {
            return ((OffsetDateTime)date).toInstant();
        }
        if (date instanceof ChronoZonedDateTime) {
            return ((ChronoZonedDateTime)date).toInstant();
        }
        if (zone != null) {
            if (date instanceof LocalDateTime) {
                LocalDateTime t = (LocalDateTime)date;
                if (zone instanceof ZoneOffset) {
                    return t.atOffset((ZoneOffset)zone).toInstant();
                }
                return t.atZone(zone).toInstant();
            }
            if (date instanceof LocalDate) {
                LocalDate t = (LocalDate)date;
                return t.atStartOfDay(zone).toInstant();
            }
        }
        if (zone == null || date.isSupported(ChronoField.INSTANT_SECONDS)) {
            time = Instant.ofEpochSecond(date.getLong(ChronoField.INSTANT_SECONDS));
            nano = ChronoField.NANO_OF_SECOND;
        } else if (zone.equals(ZoneOffset.UTC)) {
            time = Instant.ofEpochSecond(Math.multiplyExact(date.getLong(ChronoField.EPOCH_DAY), 86400));
            nano = ChronoField.NANO_OF_DAY;
        } else {
            throw new DateTimeException(Errors.format((short)11, date.getClass(), Instant.class));
        }
        if (date.isSupported(nano)) {
            time = time.plusNanos(date.getLong(nano));
        }
        return time;
    }

    @Override
    public Instant toInstant() {
        if (this.temporal instanceof Instant) {
            return (Instant)this.temporal;
        }
        return super.toInstant();
    }

    public static Instant addSeconds(Instant time, double value) {
        if (time == null || Double.isNaN(value)) {
            return null;
        }
        long r = Math.round(value);
        return time.plusSeconds(r).plusNanos(Math.round((value - (double)r) * 1.0E9));
    }

    public static int compare(Temporal t1, Temporal t2) {
        int c;
        block4: {
            c = -2;
            try {
                c = Long.compare(t1.getLong(ChronoField.INSTANT_SECONDS), t2.getLong(ChronoField.INSTANT_SECONDS));
                if (c == 0) {
                    c = Long.compare(t1.getLong(ChronoField.NANO_OF_SECOND), t2.getLong(ChronoField.NANO_OF_SECOND));
                }
            }
            catch (DateTimeException e) {
                if (c == 0) break block4;
                if (t1 instanceof Comparable && t1.getClass().isInstance(t2)) {
                    int cc = ((Comparable)((Object)t1)).compareTo((Comparable)((Object)t2));
                    return cc;
                }
                throw e;
            }
        }
        return c;
    }

    public boolean equals(Object other, ComparisonMode mode) {
        if (mode.isCompatibility() && other instanceof TemporalDate && TemporalDate.compare(this.temporal, ((TemporalDate)other).temporal) == 0) {
            return true;
        }
        return this.equals(other);
    }

    @Override
    public String toString() {
        return this.toInstant().toString() + " (" + String.valueOf(this.temporal) + ")";
    }
}

