/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.util.Collections;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.Descriptor;
import org.apache.sling.cta.impl.AgentInfo;
import org.apache.sling.cta.impl.MBeanAwareTimeoutTransformer;

public class HttpClient3TimeoutTransformer
extends MBeanAwareTimeoutTransformer {
    private static final String DEFAULT_HTTP_PARAMS_FACTORY_CLASS_NAME = Descriptor.toJvmName((String)"org.apache.commons.httpclient.params.DefaultHttpParamsFactory");
    private final long connectTimeoutMillis;
    private final long readTimeoutMillis;

    public HttpClient3TimeoutTransformer(long connectTimeoutMillis, long readTimeoutMillis, AgentInfo agentInfoMBean) {
        super(agentInfoMBean, Collections.singleton(DEFAULT_HTTP_PARAMS_FACTORY_CLASS_NAME));
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    protected byte[] doTransformClass(CtClass cc) throws Exception {
        CtMethod getSoTimeout = cc.getDeclaredMethod("createParams");
        getSoTimeout.insertAfter("$_.setParameter(\"http.connection.timeout\", Integer.valueOf(" + this.connectTimeoutMillis + "));");
        getSoTimeout.insertAfter("$_.setParameter(\"http.socket.timeout\", Integer.valueOf(" + this.readTimeoutMillis + "));");
        byte[] classfileBuffer = cc.toBytecode();
        cc.detach();
        return classfileBuffer;
    }
}

