/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api.blob;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class BlobDownloadOptions {
    private static final String DISPOSITION_TYPE_INLINE = "inline";
    private final String mediaType;
    private final String characterEncoding;
    private final String fileName;
    private final String dispositionType;
    private boolean domainOverrideIgnored = false;
    public static final BlobDownloadOptions DEFAULT = new BlobDownloadOptions();

    private BlobDownloadOptions() {
        this(null, null, null, DISPOSITION_TYPE_INLINE);
    }

    public BlobDownloadOptions(@Nullable String mediaType, @Nullable String characterEncoding, @Nullable String fileName, @NotNull String dispositionType) {
        this(mediaType, characterEncoding, fileName, dispositionType, false);
    }

    public BlobDownloadOptions(@Nullable String mediaType, @Nullable String characterEncoding, @Nullable String fileName, @NotNull String dispositionType, boolean domainOverrideIgnored) {
        if (dispositionType == null) {
            throw new NullPointerException("dispositionType must not be null");
        }
        this.mediaType = mediaType;
        this.characterEncoding = characterEncoding;
        this.fileName = fileName;
        this.dispositionType = dispositionType;
        this.domainOverrideIgnored = domainOverrideIgnored;
    }

    @Nullable
    public String getMediaType() {
        return this.mediaType;
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public String getDispositionType() {
        return this.dispositionType;
    }

    public boolean isDomainOverrideIgnored() {
        return this.domainOverrideIgnored;
    }
}

