/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ClassNameConversionRequired;
import org.eclipse.persistence.internal.descriptors.TypeMapping;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class ObjectTypeConverter
implements Converter,
ClassNameConversionRequired {
    protected String converterName;
    protected Class<?> dataType;
    protected String dataTypeName;
    protected Class<?> objectType;
    protected String objectTypeName;
    protected Map<String, String> conversionValueStrings;
    protected Map<String, String> addToAttributeOnlyConversionValueStrings;
    protected DatabaseMapping mapping;
    protected transient Map fieldToAttributeValues;
    protected Map attributeToFieldValues = new HashMap(10);
    protected transient Object defaultAttributeValue;
    protected String defaultAttributeValueString;
    protected transient Class<?> fieldClassification;
    protected transient String fieldClassificationName;

    public ObjectTypeConverter() {
        this.fieldToAttributeValues = new HashMap(10);
        this.conversionValueStrings = new HashMap<String, String>(10);
        this.addToAttributeOnlyConversionValueStrings = new HashMap<String, String>(10);
    }

    public ObjectTypeConverter(DatabaseMapping mapping) {
        this();
        this.mapping = mapping;
    }

    public void addConversionValue(Object fieldValue, Object attributeValue) {
        if (fieldValue == null) {
            fieldValue = Helper.NULL_VALUE;
        }
        if (attributeValue == null) {
            attributeValue = Helper.NULL_VALUE;
        }
        this.getFieldToAttributeValues().put(fieldValue, attributeValue);
        this.getAttributeToFieldValues().put(attributeValue, fieldValue);
    }

    public void addConversionValueStrings(String dataValue, String objectValue) {
        this.conversionValueStrings.put(dataValue, objectValue);
    }

    public void addToAttributeOnlyConversionValue(Object fieldValue, Object attributeValue) {
        if (fieldValue == null) {
            fieldValue = Helper.NULL_VALUE;
        }
        if (attributeValue == null) {
            attributeValue = Helper.NULL_VALUE;
        }
        this.getFieldToAttributeValues().put(fieldValue, attributeValue);
    }

    public void addToAttributeOnlyConversionValueStrings(String dataValue, String objectValue) {
        this.addToAttributeOnlyConversionValueStrings.put(dataValue, objectValue);
    }

    public Map getAttributeToFieldValues() {
        return this.attributeToFieldValues;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.dataTypeName != null) {
            this.dataType = this.loadClass(this.dataTypeName, classLoader);
        }
        if (this.objectTypeName != null) {
            this.objectType = this.loadClass(this.objectTypeName, classLoader);
        }
        if (this.objectType != null && this.dataType != null) {
            String objectValue;
            for (String dataValue : this.conversionValueStrings.keySet()) {
                objectValue = this.conversionValueStrings.get(dataValue);
                this.addConversionValue(this.initObject(this.dataType, dataValue, true), this.initObject(this.objectType, objectValue, false));
            }
            for (String dataValue : this.addToAttributeOnlyConversionValueStrings.keySet()) {
                objectValue = this.addToAttributeOnlyConversionValueStrings.get(dataValue);
                this.addToAttributeOnlyConversionValue(this.initObject(this.dataType, dataValue, true), this.initObject(this.objectType, objectValue, false));
            }
            if (this.defaultAttributeValueString != null) {
                this.setDefaultAttributeValue(this.initObject(this.objectType, this.defaultAttributeValueString, false));
            }
        }
    }

    protected Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                }
                catch (PrivilegedActionException e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className, e.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(className, true, classLoader);
        }
        catch (Exception exception) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception);
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        Object attributeValue = null;
        if (fieldValue == null) {
            attributeValue = this.getFieldToAttributeValues().get(Helper.NULL_VALUE);
        } else {
            try {
                fieldValue = session.getDatasourcePlatform().getConversionManager().convertObject(fieldValue, this.getFieldClassification());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
            }
            attributeValue = this.getFieldToAttributeValues().get(fieldValue);
            if (attributeValue == null) {
                if (this.getDefaultAttributeValue() != null) {
                    attributeValue = this.getDefaultAttributeValue();
                } else {
                    throw DescriptorException.noFieldValueConversionToAttributeValueProvided(fieldValue, this.getMapping().getField(), this.getMapping());
                }
            }
        }
        return attributeValue;
    }

    public Object getDefaultAttributeValue() {
        return this.defaultAttributeValue;
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    public Class<?> getFieldClassification() {
        return this.fieldClassification;
    }

    public String getFieldClassificationName() {
        if (this.fieldClassificationName == null && this.fieldClassification != null) {
            this.fieldClassificationName = this.fieldClassification.getName();
        }
        return this.fieldClassificationName;
    }

    public Class<?> getFieldClassification(DatabaseField fieldToClassify) {
        return this.getFieldClassification();
    }

    public Vector getFieldToAttributeValueAssociations() {
        Vector<TypeMapping> associations = new Vector<TypeMapping>(this.getFieldToAttributeValues().size());
        Iterator fieldValueEnum = this.getFieldToAttributeValues().keySet().iterator();
        Iterator attributeValueEnum = this.getFieldToAttributeValues().values().iterator();
        while (fieldValueEnum.hasNext()) {
            Object attributeValue;
            Object fieldValue = fieldValueEnum.next();
            if (fieldValue == Helper.NULL_VALUE) {
                fieldValue = null;
            }
            if ((attributeValue = attributeValueEnum.next()) == Helper.NULL_VALUE) {
                attributeValue = null;
            }
            associations.addElement(new TypeMapping(fieldValue, attributeValue));
        }
        return associations;
    }

    public Map getFieldToAttributeValues() {
        if (this.fieldToAttributeValues == null) {
            this.fieldToAttributeValues = new HashMap(10);
        }
        return this.fieldToAttributeValues;
    }

    @Override
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        Object fieldValue;
        if (attributeValue == null) {
            fieldValue = this.getAttributeToFieldValues().get(Helper.NULL_VALUE);
        } else {
            fieldValue = this.getAttributeToFieldValues().get(attributeValue);
            if (fieldValue == null) {
                throw DescriptorException.noAttributeValueConversionToFieldValueProvided(attributeValue, this.getMapping());
            }
        }
        return fieldValue;
    }

    public void mapBooleans() {
        this.addConversionValue("F", Boolean.FALSE);
        this.addConversionValue("T", Boolean.TRUE);
    }

    public void mapGenders() {
        this.addConversionValue("F", "Female");
        this.addConversionValue("M", "Male");
    }

    public void mapResponses() {
        this.addConversionValue("Y", "Yes");
        this.addConversionValue("N", "No");
    }

    public void initializeFieldClassification(Session session) throws DescriptorException {
        AbstractDirectMapping directMapping;
        if (this.getFieldToAttributeValues().isEmpty()) {
            return;
        }
        Class<?> type = null;
        Iterator fieldValuesEnum = this.getFieldToAttributeValues().keySet().iterator();
        while (fieldValuesEnum.hasNext() && type == null) {
            Object value = fieldValuesEnum.next();
            if (value == Helper.NULL_VALUE) continue;
            type = value.getClass();
        }
        this.setFieldClassification(type);
        if (this.getMapping().isDirectToFieldMapping() && (directMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            directMapping.setFieldClassification(type);
        }
    }

    private Object initObject(Class<?> type, String value, boolean isData) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(type, new Class[]{String.class}, false));
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{value}));
            }
            catch (PrivilegedActionException exception) {
                this.throwInitObjectException(exception, type, value, isData);
            }
        } else {
            try {
                Constructor<?> constructor = PrivilegedAccessHelper.getConstructorFor(type, new Class[]{String.class}, false);
                return PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{value});
            }
            catch (Exception exception) {
                this.throwInitObjectException(exception, type, value, isData);
            }
        }
        return null;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        this.mapping = mapping;
        this.initializeFieldClassification(session);
    }

    public void setAttributeToFieldValues(Map attributeToFieldValues) {
        this.attributeToFieldValues = attributeToFieldValues;
    }

    public void setConverterName(String converterName) {
        this.converterName = converterName;
    }

    public void setDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
    }

    public void setDefaultAttributeValue(Object defaultAttributeValue) {
        this.defaultAttributeValue = defaultAttributeValue;
    }

    public void setDefaultAttributeValueString(String defaultAttributeValueString) {
        this.defaultAttributeValueString = defaultAttributeValueString;
    }

    public void setFieldClassification(Class<?> fieldClassification) {
        this.fieldClassification = fieldClassification;
    }

    public void setFieldClassificationName(String fieldClassificationName) {
        this.fieldClassificationName = fieldClassificationName;
    }

    public void setFieldToAttributeValueAssociations(Vector fieldToAttributeValueAssociations) {
        this.setFieldToAttributeValues(new HashMap(fieldToAttributeValueAssociations.size() + 1));
        this.setAttributeToFieldValues(new HashMap(fieldToAttributeValueAssociations.size() + 1));
        Enumeration associationsEnum = fieldToAttributeValueAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = (Association)associationsEnum.nextElement();
            this.addConversionValue(association.getKey(), association.getValue());
        }
    }

    public void setFieldToAttributeValues(Map fieldToAttributeValues) {
        this.fieldToAttributeValues = fieldToAttributeValues;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    protected void throwInitObjectException(Exception exception, Class<?> type, String value, boolean isData) {
        if (isData) {
            throw ValidationException.errorInstantiatingConversionValueData(this.converterName, value, type, exception);
        }
        throw ValidationException.errorInstantiatingConversionValueObject(this.converterName, value, type, exception);
    }
}

