/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.headers;

import io.smallrye.openapi.api.models.headers.HeaderImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.media.ExampleObjectIO;
import io.smallrye.openapi.runtime.io.media.SchemaIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;

public class HeaderIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Header, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_EXAMPLE = "example";
    private static final String PROP_EXAMPLES = "examples";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_SCHEMA = "schema";
    private static final String PROP_EXPLODE = "explode";
    private static final String PROP_ALLOW_EMPTY_VALUE = "allowEmptyValue";
    private static final String PROP_REQUIRED = "required";
    private static final String PROP_DEPRECATED = "deprecated";
    private static final String PROP_STYLE = "style";
    private final SchemaIO<V, A, O, AB, OB> schemaIO;
    private final ContentIO<V, A, O, AB, OB> contentIO;
    private final ExampleObjectIO<V, A, O, AB, OB> exampleObjectIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public HeaderIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.HEADER, Names.create(Header.class));
        this.contentIO = contentIO;
        this.exampleObjectIO = new ExampleObjectIO<V, A, O, AB, OB>(context, extensionIO);
        this.schemaIO = new SchemaIO<V, A, O, AB, OB>(context, extensionIO);
        this.extensionIO = extensionIO;
    }

    @Override
    public Header read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Header");
        HeaderImpl header = new HeaderImpl();
        header.setRef(ReferenceType.HEADER.refValue(annotation));
        header.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        header.setSchema((Schema)this.schemaIO.read(annotation.value(PROP_SCHEMA)));
        header.setRequired((Boolean)this.value(annotation, PROP_REQUIRED));
        header.setDeprecated((Boolean)this.value(annotation, PROP_DEPRECATED));
        header.setAllowEmptyValue((Boolean)this.value(annotation, PROP_ALLOW_EMPTY_VALUE));
        header.setExtensions(this.extensionIO.readExtensible(annotation));
        return header;
    }

    @Override
    public Header readObject(O node) {
        IoLogging.logger.singleJsonNode("Header");
        HeaderImpl header = new HeaderImpl();
        header.setRef(this.readReference(node));
        header.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        header.setSchema((Schema)this.schemaIO.readValue(this.jsonIO().getValue(node, PROP_SCHEMA)));
        header.setRequired(this.jsonIO().getBoolean(node, PROP_REQUIRED));
        header.setDeprecated(this.jsonIO().getBoolean(node, PROP_DEPRECATED));
        header.setAllowEmptyValue(this.jsonIO().getBoolean(node, PROP_ALLOW_EMPTY_VALUE));
        header.setStyle(this.enumValue(this.jsonIO().getValue(node, PROP_STYLE), Header.Style.class));
        header.setExplode(this.jsonIO().getBoolean(node, PROP_EXPLODE));
        header.setExample(this.jsonIO().fromJson(this.jsonIO().getValue(node, PROP_EXAMPLE)));
        header.setExamples(this.exampleObjectIO.readMap(this.jsonIO().getValue(node, PROP_EXAMPLES)));
        header.setContent((Content)this.contentIO.readValue(this.jsonIO().getValue(node, PROP_CONTENT)));
        header.setExtensions(this.extensionIO.readMap(node));
        return header;
    }

    @Override
    public Optional<O> write(Header model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
            } else {
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, PROP_REQUIRED, this.jsonIO().toJson(model.getRequired()));
                this.setIfPresent(node, PROP_DEPRECATED, this.jsonIO().toJson(model.getDeprecated()));
                this.setIfPresent(node, PROP_ALLOW_EMPTY_VALUE, this.jsonIO().toJson(model.getAllowEmptyValue()));
                this.setIfPresent(node, PROP_STYLE, this.jsonIO().toJson(model.getStyle()));
                this.setIfPresent(node, PROP_EXPLODE, this.jsonIO().toJson(model.getExplode()));
                this.setIfPresent(node, PROP_SCHEMA, this.schemaIO.write(model.getSchema()));
                this.setIfPresent(node, PROP_EXAMPLE, this.jsonIO().toJson(model.getExample()));
                this.setIfPresent(node, PROP_EXAMPLES, this.exampleObjectIO.write(model.getExamples()));
                this.setIfPresent(node, PROP_CONTENT, this.contentIO.write(model.getContent()));
                this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

